<?PHP
/*
 * Adjustments by Taifun
 * using Scott's abandoned Email with single attachment solution, which can be found at
 * https://groups.google.com/forum/#!msg/app-inventor-developers-library/-6XI0hWHqao/1zzc0jEm0iwJ
 *
 * Date: Feb 11, 2016
 * Contact: info@puravidaapps.com
 *
 * A Web component support service to allow emailing with an optional file attachment from App Inventor apps
 *
 * Usage  http://PATH TO THE SCRIPT/sendmail.php?p=(accesskey)&fi=(file name)&to=(to)&fr=(from)&su=(subject)&bo=(body)
 *
 * Version 2.0: complete cleanup of previous version and now using PHPMailer to send mails
 * Version 2.1: added HTML formatting
 *
 *
 * IMPORTANT NOTE: this solution works until PHP VERSION 5.3,
 *                 for newer php versions HTML formatting and sending attachments does not work anymore!
 */

/************************************CONFIG****************************************/

//SETTINGS//
//This code is something you set in the APP so random people cant use it.
$ACCESSKEY="atx806";

// this text will be displayed as sender
$SENDER="Pura Vida Mail Service";

/************************************CONFIG****************************************/

$to       = urldecode($_GET['to']);
$from     = urldecode($_GET['from']);
$subject  = urldecode($_GET['subject']);
$body     = "<html><body>" . urldecode($_GET['body']) . "</body></html>"; // HTML formatting added
$filename = urldecode($_GET['filename']);



if($_GET['p']==$ACCESSKEY){
  if ($filename != ''){
    // this is the workaround for file_get_contents(...)
    require_once (dirname(__FILE__).'/PHP_Compat-1.6.0a3/Compat/Function/file_get_contents.php');
    //$data = php_compat_file_get_contents('php://input');          // note: some servers require 'php://stdin' instead!
    $data = php_compat_file_get_contents('php://stdin');          // note: some servers require 'php://stdin' instead!

    if (file_put_contents($filename, $data) === FALSE) die("Upload failed, send cancelled.");
    $file_size = filesize($filename);

    // limit attachment to 10MB
    if ($file_size > 20485760) die("> 10MB. Send cancelled.");

    // save file attachment info in log
    $emtemp = 'emailtemp.log';

    // this is the workaround for file_get_contents(...)
    $current = php_compat_file_get_contents($emtemp);
    $current .= gmdate("Y-m-d\TH:i:s") . ", " . $filename . ", " . round($file_size/2048576, 3) . "MB\n";
    file_put_contents($emtemp, $current);
  }

  // email solution using PHPMailer, http://github.com/PHPMailer/PHPMailer
  require_once (dirname(__FILE__).'/PHPMailer-master/class.phpmailer.php');
  $email = new PHPMailer();
  $email->From      = $from;
  $email->FromName  = $SENDER;
  $email->Subject   = $subject;
  $email->Body      = $body;
  $email->AddAddress( $to );
  $email->IsHTML(true);          // HTML formatting added

  if ($filename != ''){
    $email->AddAttachment( $filename , $filename );
  }

  if(!$email->send()) {
    header("HTTP/1.0 400 Bad Request");
    echo "Message could not be sent.";
    echo "Mailer Error: " . $mail->ErrorInfo;
    exit;
  }
  echo "Message has been sent";
} else {
  header("HTTP/1.0 400 Bad Request");
  echo "Access denied";     //reports if accesskey is wrong
}

?>