angular.module("noticias_ela", ["ngCordova","ionic","ionMdInput","ionic-material","ion-datetime-picker","ionic.rating","utf8-base64","angular-md5","chart.js","pascalprecht.translate","tmh.dynamicLocale","noticias_ela.controllers", "noticias_ela.services"])
	.run(function($ionicPlatform,$window,$interval,$timeout,$ionicHistory,$ionicPopup,$state,$rootScope){

		$rootScope.appName = "NoticiasELA" ;
		$rootScope.appLogo = "data/images/header/logo.png" ;
		$rootScope.appVersion = "1.1" ;
		$rootScope.headerShrink = false ;

		$rootScope.liveStatus = "pause" ;
		$ionicPlatform.ready(function(){
			$rootScope.liveStatus = "run" ;
		});
		$ionicPlatform.on("pause",function(){
			$rootScope.liveStatus = "pause" ;
		});
		$ionicPlatform.on("resume",function(){
			$rootScope.liveStatus = "run" ;
		});


		$rootScope.hide_menu_dashboard = false ;
		$rootScope.hide_menu_inicio = false ;
		$rootScope.hide_menu_noticias_ela = false ;
		$rootScope.hide_menu_twitter = false ;
		$rootScope.hide_menu_indicadores = false ;
		$rootScope.hide_menu_faqs = false ;
		$rootScope.hide_menu_rate_this_app = false ;
		$rootScope.hide_menu_contacto = false ;
		$rootScope.hide_menu_iniciar_sesin = false ;
		$rootScope.hide_menu_menu9 = false ;
		$rootScope.hide_menu_menu10 = false ;
		$rootScope.hide_menu_menu11 = false ;


		$ionicPlatform.ready(function() {

			localforage.config({
				driver : [localforage.WEBSQL,localforage.INDEXEDDB,localforage.LOCALSTORAGE],
				name : "noticias_ela",
				storeName : "noticias_ela",
				description : "The offline datastore for Noticias ELA app"
			});

			if(window.cordova){
				$rootScope.exist_cordova = true ;
			}else{
				$rootScope.exist_cordova = false ;
			}
			//required: cordova plugin add ionic-plugin-keyboard --save
			if(window.cordova && window.cordova.plugins.Keyboard) {
				cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
				cordova.plugins.Keyboard.disableScroll(true);
			}

			//required: cordova plugin add cordova-plugin-statusbar --save
			if(window.StatusBar) {
				//StatusBar.styleDefault();
			}


			//required: cordova plugin add onesignal-cordova-plugin --save
			if(window.plugins && window.plugins.OneSignal){
				window.plugins.OneSignal.enableNotificationsWhenActive(true);
				var notificationOpenedCallback = function(jsonData){
					try {
						$timeout(function(){
							$window.location = "#/noticias_ela/" + jsonData.notification.payload.additionalData.page ;
						},200);
					} catch(e){
						console.log("onesignal:" + e);
					}
				}
				if (ionic.Platform.isAndroid()){
					window.plugins.OneSignal.startInit("b63b68ae-e0a1-469e-9d71-ee7bd70550c8","885772279527").handleNotificationOpened(notificationOpenedCallback).endInit();
				}else{
					window.plugins.OneSignal.startInit("b63b68ae-e0a1-469e-9d71-ee7bd70550c8").handleNotificationOpened(notificationOpenedCallback).endInit();
				}
			}

			// required: cordova plugin add cordova-plugin-app-update@latest --save
			if(window.plugins && window.AppUpdate){
				if (ionic.Platform.isAndroid()){
					
					var updateUrl = "http://app.ela.com.mx/noticiasela/update.xml";
					var onSuccessAppUpdate = function(){
					}
					
					var onFailAppUpdate = function(){
					}
					
					window.AppUpdate.checkAppUpdate(onSuccessAppUpdate, onFailAppUpdate, updateUrl);
				}
			}

		});
		$ionicPlatform.registerBackButtonAction(function (e){
			if($ionicHistory.backView()){
				$ionicHistory.goBack();
			}else{
				$state.go("noticias_ela.dashboard");
			}
			e.preventDefault();
			return false;
		},101);
	})


	.filter("to_trusted", ["$sce", function($sce){
		return function(text) {
			return $sce.trustAsHtml(text);
		};
	}])

	.filter("trustUrl", function($sce) {
		return function(url) {
			return $sce.trustAsResourceUrl(url);
		};
	})

	.filter("trustJs", ["$sce", function($sce){
		return function(text) {
			return $sce.trustAsJs(text);
		};
	}])

	.filter("strExplode", function() {
		return function($string,$delimiter) {
			if(!$string.length ) return;
			var $_delimiter = $delimiter || "|";
			return $string.split($_delimiter);
		};
	})

	.filter("strDate", function(){
		return function (input) {
			return new Date(input);
		}
	})
	.filter("phpTime", function(){
		return function (input) {
			var timeStamp = parseInt(input) * 1000;
			return timeStamp ;
		}
	})
	.filter("strHTML", ["$sce", function($sce){
		return function(text) {
			return $sce.trustAsHtml(text);
		};
	}])
	.filter("strEscape",function(){
		return window.encodeURIComponent;
	})
	.filter("strUnscape", ["$sce", function($sce) {
		var div = document.createElement("div");
		return function(text) {
			div.innerHTML = text;
			return $sce.trustAsHtml(div.textContent);
		};
	}])

	.filter("stripTags", ["$sce", function($sce){
		return function(text) {
			return text.replace(/(<([^>]+)>)/ig,"");
		};
	}])

	.filter("chartData", function(){
		return function (obj) {
			var new_items = [];
			angular.forEach(obj, function(child) {
				var new_item = [];
				var indeks = 0;
				angular.forEach(child, function(v){
						if ((indeks !== 0) && (indeks !== 1)){
							new_item.push(v);
						}
						indeks++;
					});
					new_items.push(new_item);
				});
			return new_items;
		}
	})

	.filter("chartLabels", function(){
		return function (obj){
			var new_item = [];
			angular.forEach(obj, function(child) {
			var indeks = 0;
			new_item = [];
			angular.forEach(child, function(v,l) {
				if ((indeks !== 0) && (indeks !== 1)) {
					new_item.push(l);
				}
				indeks++;
			});
			});
			return new_item;
		}
	})
	.filter("chartSeries", function(){
		return function (obj) {
			var new_items = [];
			angular.forEach(obj, function(child) {
				var new_item = [];
				var indeks = 0;
				angular.forEach(child, function(v){
						if (indeks === 1){
							new_item.push(v);
						}
						indeks++;
					});
					new_items.push(new_item);
				});
			return new_items;
		}
	})



.config(["$translateProvider", function ($translateProvider){
	$translateProvider.preferredLanguage("en-us");
	$translateProvider.useStaticFilesLoader({
		prefix: "translations/",
		suffix: ".json"
	});
	$translateProvider.useSanitizeValueStrategy("escapeParameters");
}])


.config(function(tmhDynamicLocaleProvider){
	tmhDynamicLocaleProvider.localeLocationPattern("lib/ionic/js/i18n/angular-locale_{{locale}}.js");
	tmhDynamicLocaleProvider.defaultLocale("en-us");
})


.config(function($stateProvider, $urlRouterProvider,$sceDelegateProvider,$httpProvider,$ionicConfigProvider){
	try{
		// Domain Whitelist
		$sceDelegateProvider.resourceUrlWhitelist([
			"self",
			new RegExp('^(http[s]?):\/\/(w{3}.)?youtube\.com/.+$'),
			new RegExp('^(http[s]?):\/\/(w{3}.)?w3schools\.com/.+$'),
		]);
	}catch(err){
		console.log("%cerror: %cdomain whitelist","color:blue;font-size:16px;","color:red;font-size:16px;");
	}
	$stateProvider
	.state("noticias_ela",{
		url: "/noticias_ela",
			abstract: true,
			templateUrl: "templates/noticias_ela-side_menus.html",
			controller: "side_menusCtrl",
	})

	.state("noticias_ela.about_us", {
		url: "/about_us",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-about_us.html",
						controller: "about_usCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.bookmarks", {
		url: "/bookmarks",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-bookmarks.html",
						controller: "bookmarksCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.contacto", {
		url: "/contacto",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-contacto.html",
						controller: "contactoCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.dashboard", {
		url: "/dashboard",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-dashboard.html",
						controller: "dashboardCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.faqs", {
		url: "/faqs",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-faqs.html",
						controller: "faqsCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.faqs_bookmark", {
		url: "/faqs_bookmark",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-faqs_bookmark.html",
						controller: "faqs_bookmarkCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.faqs_singles", {
		url: "/faqs_singles/:id",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-faqs_singles.html",
						controller: "faqs_singlesCtrl"
					},
			"fabButtonUp" : {
						template: '<button id="fab-up-button" ng-click="scrollTop()" class="button button-fab button-fab-bottom-right button-energized-900 spin"><i class="icon ion-arrow-up-a"></i></button>',
						controller: function ($timeout) {
							$timeout(function () {
								document.getElementById("fab-up-button").classList.toggle("on");
							}, 900);
						}
					},
		}
	})

	.state("noticias_ela.form_contacto", {
		url: "/form_contacto",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-form_contacto.html",
						controller: "form_contactoCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.help", {
		url: "/help",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-help.html",
						controller: "helpCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.indicadores", {
		url: "/indicadores",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-indicadores.html",
						controller: "indicadoresCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.indicadores_singles", {
		url: "/indicadores_singles/:id",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-indicadores_singles.html",
						controller: "indicadores_singlesCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.iniciar_sesin", {
		url: "/iniciar_sesin",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-iniciar_sesin.html",
						controller: "iniciar_sesinCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.inicio", {
		url: "/inicio",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-inicio.html",
						controller: "inicioCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.menu10", {
		url: "/menu10",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-menu10.html",
						controller: "menu10Ctrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.menu11", {
		url: "/menu11",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-menu11.html",
						controller: "menu11Ctrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.menu9", {
		url: "/menu9",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-menu9.html",
						controller: "menu9Ctrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.noticias_ela", {
		url: "/noticias_ela",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-noticias_ela.html",
						controller: "noticias_elaCtrl"
					},
			"fabButtonUp" : {
						template: '<button id="fab-up-button" ng-click="scrollTop()" class="button button-fab button-fab-bottom-right button-energized-900 spin"><i class="icon ion-arrow-up-a"></i></button>',
						controller: function ($timeout) {
							$timeout(function () {
								document.getElementById("fab-up-button").classList.toggle("on");
							}, 900);
						}
					},
		}
	})

	.state("noticias_ela.noticias_ela_bookmark", {
		url: "/noticias_ela_bookmark",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-noticias_ela_bookmark.html",
						controller: "noticias_ela_bookmarkCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.noticias_ela_singles", {
		url: "/noticias_ela_singles/:id",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-noticias_ela_singles.html",
						controller: "noticias_ela_singlesCtrl"
					},
			"fabButtonUp" : {
						template: '<button id="fab-up-button" ng-click="scrollTop()" class="button button-fab button-fab-bottom-right button-energized-900 spin"><i class="icon ion-arrow-up-a"></i></button>',
						controller: function ($timeout) {
							$timeout(function () {
								document.getElementById("fab-up-button").classList.toggle("on");
							}, 900);
						}
					},
		}
	})

	.state("noticias_ela.rutafiscal_singles", {
		url: "/rutafiscal_singles/:id",
		cache:false,
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-rutafiscal_singles.html",
						controller: "rutafiscal_singlesCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.slide_tab_menu", {
		url: "/slide_tab_menu",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-slide_tab_menu.html",
						controller: "slide_tab_menuCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.twitter", {
		url: "/twitter",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-twitter.html",
						controller: "twitterCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.twitter_singles", {
		url: "/twitter_singles/:id",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-twitter_singles.html",
						controller: "twitter_singlesCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.user_login", {
		url: "/user_login",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-user_login.html",
						controller: "user_loginCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.user_profile", {
		url: "/user_profile",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-user_profile.html",
						controller: "user_profileCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	.state("noticias_ela.user_register", {
		url: "/user_register",
		views: {
			"noticias_ela-side_menus" : {
						templateUrl:"templates/noticias_ela-user_register.html",
						controller: "user_registerCtrl"
					},
			"fabButtonUp" : {
						template: '',
					},
		}
	})

	$urlRouterProvider.otherwise("/noticias_ela/dashboard");
});
