<?php


/**
 * @author Adrian Ruvalcaba Espinosa <comercializacion@codeapps.mx>
 * @copyright CodeApps.Mx 2019
 * @package noticias_ela
 * 
 * 
 * Created using Ionic App Builder
 * http://codecanyon.net/item/ionic-mobile-app-builder/15716727
 */


/** CONFIG:START **/
$config["host"] 		= "localhost" ; 		//host
$config["user"] 		= "root" ; 		//Username SQL
$config["pass"] 		= "" ; 		//Password SQL
$config["dbase"] 		= "db_noticias_ela" ; 		//Database
$config["utf8"] 		= true ; 		//turkish charset set false
$config["timezone"] 		= "Asia/Jakarta" ; 		// check this site: http://php.net/manual/en/timezones.php
$config["abs_url_images"] 		= "http://domain.com/apps/noticias_ela//media/image/" ; 		//Absolute Images URL
$config["abs_url_videos"] 		= "http://domain.com/apps/noticias_ela//media/media/" ; 		//Absolute Videos URL
$config["abs_url_audios"] 		= "http://domain.com/apps/noticias_ela//media/media/" ; 		//Absolute Audio URL
$config["abs_url_files"] 		= "http://domain.com/apps/noticias_ela//media/file/" ; 		//Absolute Files URL
$config["image_allowed"][] 		= array("mimetype"=>"image/jpeg","ext"=>"jpg") ; 		//whitelist image
$config["image_allowed"][] 		= array("mimetype"=>"image/jpg","ext"=>"jpg") ; 		
$config["image_allowed"][] 		= array("mimetype"=>"image/png","ext"=>"png") ; 		
$config["file_allowed"][] 		= array("mimetype"=>"text/plain","ext"=>"txt") ; 		
$config["file_allowed"][] 		= array("mimetype"=>"","ext"=>"tmp") ; 		
/** CONFIG:END **/
error_reporting(0);

ini_set('internal_encoding', 'utf-8');
date_default_timezone_set($config['timezone']);
if(isset($_SERVER["HTTP_X_AUTHORIZATION"])){
	list($_SERVER["PHP_AUTH_USER"],$_SERVER["PHP_AUTH_PW"]) = explode(":" , base64_decode(substr($_SERVER["HTTP_X_AUTHORIZATION"],6)));
}
$rest_api=array("data"=>array("status"=>404,"title"=>"Not found"),"title"=>"Error","message"=>"Routes not found");

/** connect to mysql **/
$mysql = new mysqli($config["host"], $config["user"], $config["pass"], $config["dbase"]);
if (mysqli_connect_errno()){
	die(mysqli_connect_error());
}


if(!isset($_GET["json"])){
	$_GET["json"]= "route";
}
if((!isset($_GET["form"])) && ($_GET["json"] == "submit")) {
	$_GET["json"]= "route";
}

if($config["utf8"]==true){
	$mysql->set_charset("utf8");
}

$get_dir = explode("/", $_SERVER["PHP_SELF"]);
unset($get_dir[count($get_dir)-1]);
$main_url = "http://" . $_SERVER["HTTP_HOST"] . implode("/",$get_dir)."/".$_SERVER["PHP_SELF"];


switch($_GET["json"]){	
	// TODO: -+- Listing : contacto
	case "contacto":
		$rest_api=array();
		$where = $_where = null;
		// TODO: -+----+- statement where
		if(isset($_GET["feedback_email"])){
			if($_GET["feedback_email"]!="-1"){
				$_where[] = "`feedback_email` LIKE '".$mysql->escape_string($_GET["feedback_email"])."'";
			}
		}
		if(isset($_GET["feedback_name"])){
			if($_GET["feedback_name"]!="-1"){
				$_where[] = "`feedback_name` LIKE '".$mysql->escape_string($_GET["feedback_name"])."'";
			}
		}
		if(isset($_GET["feedback_message"])){
			if($_GET["feedback_message"]!="-1"){
				$_where[] = "`feedback_message` LIKE '".$mysql->escape_string($_GET["feedback_message"])."'";
			}
		}
		if(isset($_GET["feedback_id"])){
			if($_GET["feedback_id"]!="-1"){
				$_where[] = "`feedback_id` = '".$mysql->escape_string($_GET["feedback_id"])."'";
			}
		}
		if(is_array($_where)){
			$where = " WHERE " . implode(" AND ",$_where);
		}
		// TODO: -+----+- orderby
		$order_by = "`feedback_id`";
		$sort_by = "DESC";
		if(!isset($_GET["order"])){
			$_GET["order"] = "`feedback_id`";
		}
		// TODO: -+----+- sort asc/desc
		if(!isset($_GET["sort"])){
			$_GET["sort"] = "desc";
		}
		if($_GET["sort"]=="asc"){
			$sort_by = "ASC";
		}else{
			$sort_by = "DESC";
		}
		if($_GET["order"]=="feedback_id"){
			$order_by = "`feedback_id`";
		}
		if($_GET["order"]=="feedback_email"){
			$order_by = "`feedback_email`";
		}
		if($_GET["order"]=="feedback_name"){
			$order_by = "`feedback_name`";
		}
		if($_GET["order"]=="feedback_message"){
			$order_by = "`feedback_message`";
		}
		if($_GET["order"]=="random"){
			$order_by = "RAND()";
		}
		$limit = 100;
		if(isset($_GET["limit"])){
			$limit = (int)$_GET["limit"] ;
		}
		// TODO: -+----+- SQL Query
		$sql = "SELECT * FROM `contacto` ".$where."ORDER BY ".$order_by." ".$sort_by." LIMIT 0, ".$limit." " ;
		if($result = $mysql->query($sql)){
			$z=0;
			while ($data = $result->fetch_array()){
				if(isset($data['feedback_id'])){$rest_api[$z]['feedback_id'] = $data['feedback_id'];}; # id
				if(isset($data['feedback_email'])){$rest_api[$z]['feedback_email'] = $data['feedback_email'];}; # text
				if(isset($data['feedback_name'])){$rest_api[$z]['feedback_name'] = $data['feedback_name'];}; # text
				if(isset($data['feedback_message'])){$rest_api[$z]['feedback_message'] = $data['feedback_message'];}; # text
				$z++;
			}
			$result->close();
			if(isset($_GET["feedback_id"])){
				if(isset($rest_api[0])){
					$rest_api = $rest_api[0];
				}else{
					$rest_api=array("data"=>array("status"=>404,"title"=>"Not found"),"title"=>"Error","message"=>"Invalid ID");
				}
			}
		}

		break;
	// TODO: -+- route
	case "route":		$rest_api=array();
		$rest_api["site"]["name"] = "Noticias ELA" ;
		$rest_api["site"]["description"] = "noticias ela" ;
		$rest_api["site"]["imabuilder"] = "rev19.10.17" ;

		$rest_api["routes"][0]["namespace"] = "contacto";
		$rest_api["routes"][0]["tb_version"] = "Upd.1910160509";
		$rest_api["routes"][0]["methods"][] = "GET";
		$rest_api["routes"][0]["args"]["feedback_id"] = array("required"=>"false","description"=>"Selecting `contacto` based `feedback_id`");
		$rest_api["routes"][0]["args"]["feedback_email"] = array("required"=>"false","description"=>"Selecting `contacto` based `feedback_email`");
		$rest_api["routes"][0]["args"]["feedback_name"] = array("required"=>"false","description"=>"Selecting `contacto` based `feedback_name`");
		$rest_api["routes"][0]["args"]["feedback_message"] = array("required"=>"false","description"=>"Selecting `contacto` based `feedback_message`");
		$rest_api["routes"][0]["args"]["order"] = array("required"=>"false","description"=>"order by `random`, `feedback_id`, `feedback_email`, `feedback_name`, `feedback_message`");
		$rest_api["routes"][0]["args"]["sort"] = array("required"=>"false","description"=>"sort by `asc` or `desc`");
		$rest_api["routes"][0]["args"]["limit"] = array("required"=>"false","description"=> "limit the items that appear","type"=>"number");
		$rest_api["routes"][0]["_links"]["self"] = "http://" . $_SERVER["HTTP_HOST"] . $_SERVER["PHP_SELF"]."?json=contacto";
		$rest_api["routes"][1]["namespace"] = "submit/contacto";
		$rest_api["routes"][1]["tb_version"] = "Upd.1910160509";
		$rest_api["routes"][1]["methods"][] = "POST";
		$rest_api["routes"][1]["_links"]["self"] = "http://" . $_SERVER["HTTP_HOST"] . $_SERVER["PHP_SELF"]."?json=submit&form=contacto";
		$rest_api["routes"][1]["args"]["feedback_email"] = array("required"=>"true","description"=>"Insert data to field `Tu Correo` in table `contacto`");
		$rest_api["routes"][1]["args"]["feedback_name"] = array("required"=>"true","description"=>"Insert data to field `` in table `contacto`");
		$rest_api["routes"][1]["args"]["feedback_message"] = array("required"=>"true","description"=>"Insert data to field `Mensaje` in table `contacto`");
		$rest_api["routes"][1]["args"]["feedback_celular"] = array("required"=>"true","description"=>"Insert data to field `Celular` in table `contacto`");
		$rest_api["routes"][1]["args"]["foto"] = array("required"=>"true","description"=>"Insert data to field `AdjuntarFoto` in table `contacto`");
		break;
	// TODO: -+- submit

	case "submit":
		$rest_api=array();

		$rest_api["methods"][0] = "POST";
		$rest_api["methods"][1] = "GET";
		switch($_GET["form"]){
			// TODO: -+----+- contacto
			case "contacto":


				$rest_api["auth"]["basic"] = false;

				$rest_api["args"]["feedback_email"] = array("required"=>"true","description"=>"Receiving data from the input `Tu Correo`");
				$rest_api["args"]["feedback_name"] = array("required"=>"true","description"=>"Receiving data from the input ``");
				$rest_api["args"]["feedback_message"] = array("required"=>"true","description"=>"Receiving data from the input `Mensaje`");
				$rest_api["args"]["feedback_celular"] = array("required"=>"true","description"=>"Receiving data from the input `Celular`");
				$rest_api["args"]["foto"] = array("required"=>"true","description"=>"Receiving data from the input `AdjuntarFoto`");
				if(!isset($_POST["feedback_email"])){
					$_POST["feedback_email"]="";
				}
				if(!isset($_POST["feedback_name"])){
					$_POST["feedback_name"]="";
				}
				if(!isset($_POST["feedback_message"])){
					$_POST["feedback_message"]="";
				}
				if(!isset($_POST["feedback_celular"])){
					$_POST["feedback_celular"]="";
				}
				if(!isset($_POST["foto"])){
					$_POST["foto"]="";
				}
				$rest_api["message"] = "Please! complete the form provided.";
				$rest_api["title"] = "Notice!";
				if(($_POST["feedback_email"] != "") || ($_POST["feedback_name"] != "") || ($_POST["feedback_message"] != "") || ($_POST["feedback_celular"] != "") || ($_POST["foto"] != "")){
					// avoid undefined
					$input["feedback_email"] = "";
					$input["feedback_name"] = "";
					$input["feedback_message"] = "";
					$input["feedback_celular"] = "";
					$input["foto"] = "";
					// variable post
					if(isset($_POST["feedback_email"])){
						$input["feedback_email"] = $mysql->escape_string($_POST["feedback_email"]);
					}

					if(isset($_POST["feedback_name"])){
						$input["feedback_name"] = $mysql->escape_string($_POST["feedback_name"]);
					}

					if(isset($_POST["feedback_message"])){
						$input["feedback_message"] = $mysql->escape_string($_POST["feedback_message"]);
					}

					if(isset($_POST["feedback_celular"])){
						$input["feedback_celular"] = $mysql->escape_string($_POST["feedback_celular"]);
					}

					$invalid_file = true;
					if(isset($_POST["foto"])){
						if(!is_dir("media/image/")){
							mkdir("media/image/",0777,true);
						}
						if(!is_dir("media/media/")){
							mkdir("media/media/",0777,true);
						}
						if(!is_dir("media/file/")){
							mkdir("media/file/",0777,true);
						}
						foreach($config["image_allowed"] as $image_allowed){// whitelist mimetype
							$mimetype_image_allowed[] = $image_allowed["mimetype"];// create list
						}
						$parse_file = explode(";",substr($_POST["foto"],5,strlen($_POST["foto"])));// parsing file
						$file_foto = base64_decode(str_replace("base64,","",$parse_file[1]));
						if(in_array(strtolower($parse_file[0]),$mimetype_image_allowed)){// whitelist image
							$ext = "tmp";
							foreach($config["image_allowed"] as $image_allowed){// searching extention
								if(strtolower($parse_file[0])==$image_allowed["mimetype"]){// filter
									$invalid_file = false;
									$ext = $image_allowed["ext"];
									$file_name = "foto-" . sha1($file_foto).".".$ext;
									file_put_contents("media/image/".$file_name,$file_foto);
									$input["foto"] = $config["abs_url_images"] ."/".  $mysql->escape_string($file_name);
								}
							}
						}else{// whitelist files
							$invalid_file = true;
							$ext = "tmp";
							foreach($config["file_allowed"] as $file_allowed){
								if(strtolower($parse_file[0])==$file_allowed["mimetype"]){
									$invalid_file = false;
									$ext = $file_allowed["ext"];
									$file_name = "foto-" . sha1($file_foto).".".$ext;
									file_put_contents("media/file/".$file_name,$file_foto);
									$input["foto"] = $config["abs_url_files"] ."/".  $mysql->escape_string($file_name);
								}
							}
						}
					}
					$sql_query = "INSERT INTO `contacto` (`feedback_email`,`feedback_name`,`feedback_message`,`feedback_celular`,`foto`) VALUES ('".$input["feedback_email"]."','".$input["feedback_name"]."','".$input["feedback_message"]."','".$input["feedback_celular"]."','".$input["foto"]."' )";
					if($invalid_file ==false){
						if($query = $mysql->query($sql_query)){
							$rest_api["message"] = "Your request has been sent.";
							$rest_api["title"] = "Successfully";
						}else{
							$rest_api["message"] = "Form input and SQL Column do not match.";
							$rest_api["title"] = "Fatal Error!";
						}
					}else{
							$rest_api["message"] = "Please upload valid file";
							$rest_api["title"] = "File invalid!";
					}
				}else{
					$rest_api["message"] = "Please! complete the form provided.";
					$rest_api["title"] = "Notice!";
				}

				break;

		}


	break;

}


header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: GET,PUT,POST,DELETE,PATCH,OPTIONS');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization,X-Authorization');
if (!isset($_GET["callback"])){
	header('Content-type: application/json');
	if(defined("JSON_UNESCAPED_UNICODE")){
		echo json_encode($rest_api,JSON_UNESCAPED_UNICODE);
	}else{
		echo json_encode($rest_api);
	}

}else{
	if(defined("JSON_UNESCAPED_UNICODE")){
		echo strip_tags($_GET["callback"]) ."(". json_encode($rest_api,JSON_UNESCAPED_UNICODE). ");" ;
	}else{
		echo strip_tags($_GET["callback"]) ."(". json_encode($rest_api) . ");" ;
	}

}